absTol = 1e-3; % default is 1e-6; 1e-5 and even 1e-4 seem to also be ok
relTol = 1e-2; % default is 1e-3; 1e-2 seems also fine
maxStep = 300;
% but not sure if higher tolerances actually reduce running time


simType = 'hps';
filter = 'none'; % dark, 'darkNoScreens'; % noLampsNoScreens, none
simRes = 1; ctrlRes = 300; % step size when solving [s] 

scenBegin = 1;
scenEnd = 1; % up to 9
numSim = scenEnd-scenBegin+1;

seasonLength = 112; % 125; % season length in days (data length is 126 days, 112 if you need co2 injection)
firstDay = 1; % 46 or 78 or 80.2 days since beginning of data        


bv = StateSpaceModel;

[outdoor, indoor, controls, startTime, filtInd] = loadGreenhouseData(firstDay, seasonLength, simType, filter);

indoor(:,3) = vaporDens2pres(indoor(:,2), indoor(:,3));
        % convert vapor density to vapor pressure

indoor(:,4) = 1e6*co2ppm2dens(indoor(:,2),indoor(:,4));
        % convert co2 from ppm to mg m^{-3}
 
v.tAir = DynamicElement('v.tAir', [floor(indoor(:,1)) indoor(:,2)]);
v.vpAir = DynamicElement('v.vpAir', [floor(indoor(:,1)) indoor(:,3)]);
v.co2Air = DynamicElement('v.co2Air', [floor(indoor(:,1)) indoor(:,4)]);
	
secsInYear = seconds(startTime-datetime(year(startTime),1,1,0,0,0));
    % number of seconds since beginning of year to startTime

outdoor(:,7) = skyTempRdam(outdoor(:,3), datenum(startTime)+outdoor(:,1)/86400); % add sky temperature
outdoor(:,8) = soilTempNl(secsInYear+outdoor(:,1)); % add soil temperature

n=1;
% for n=1:7

    bv = createBvModel(outdoor, startTime, controls, indoor);
    feval(['set' upper(simType(1)) simType(2:end) 'Params'], bv(n));
    bv.p.simRes.val = simRes; 
              
    setParam(bv,'cLeakage', 3e-5);
    setParam(bv,'aRoof', 52.2);

    setParam(bv,'kBlScr',5e-4);

    setParam(bv,'kThScr',5e-4);
   
    setParam(bv, 'cWgh', 0.02); % default is 0.09
    setParam(bv, 'cDgh', 0.35); % default is 0.75
    
    bv.x.cLeaf.val = 0.7*6240*10;
    bv.x.cStem.val = 0.25*6240*10;
    bv.x.cFruit.val = 0.05*6240*10;
    
    setParam(bv(n), 'cHecIn', 3.5);

    setParam(bv, 'epsLampTop', 0.1)
    
    saveTo = ['climateModel_' simType '_manuscriptParams'];% num2str(n)];
    fprintf('saving to %s\n', saveTo);

    seasonLength = bv.t.val(2)/86400; % season length in days, after filtering

    timer = tic;
    fprintf('(%d of %d) Start time: %s; Estimated run time: %s; ETA: %s\n', ...
        n, numSim, datetime('now'), datestr(seconds(seasonLength*15), 'HH:MM:SS'), ...
        datestr(datetime('now')+seconds(seasonLength*18)));
    
    options = odeset('Vectorized','on','AbsTol', absTol, 'RelTol', relTol, 'MaxStep', maxStep);
    options = [];

%     odeSolve(bv,'ode15s', options);
    makeScript(bv,'localhps.m','localhps');
    localhps(bv, 'ode15s', options);
    delete('localhps.m');


    fprintf('Actual run time: %s; End time: %s\n', ...
         datestr(seconds(toc(timer)), 'HH:MM:SS'), datetime('now'));

    bv = changeRes(bv,300);

    rrmseTair = sqrt(mean((bv.x.tAir.val(:,2)-v.tAir.val(:,2)).^2))./mean(v.tAir.val(:,2));
    rrmseVpair = sqrt(mean((bv.x.vpAir.val(:,2)-v.vpAir.val(:,2)).^2))./mean(v.vpAir.val(:,2));
    rrmseCo2air  = sqrt(mean((bv.x.co2Air.val(:,2)-v.co2Air.val(:,2)).^2))./mean(v.co2Air.val(:,2));
    
    save(saveTo);
% end

beep